/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.credits;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.credits.CreditLine;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.CreditStrings;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import java.util.ArrayList;

public class CreditsScreen {
    private static final CreditStrings creditStrings = CardCrawlGame.languagePack.getCreditString("Credits");
    private static final String[] NAMES = CreditsScreen.creditStrings.NAMES;
    private static final String THANKS_MSG = CreditsScreen.creditStrings.THANKS_MSG;
    private Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private float fadeInTimer = 2.0f;
    private float targetY;
    private float currentY;
    private static final float scrollSpeed = 50.0f * Settings.scale;
    private static final int W = 720;
    private ArrayList<CreditLine> lines = new ArrayList();
    private static final float LINE_SPACING = 45.0f;
    private static final float SECTION_SPACING = 150.0f;
    private static final float SCROLL_START_Y = 400.0f * Settings.scale;
    private static final float THANK_YOU_TIME = 3.0f;
    private float thankYouTimer = 3.0f;
    private Color thankYouColor = Settings.CREAM_COLOR.cpy();
    private static final float END_OF_CREDITS_Y = 4300.0f * Settings.scale;
    private static final String SKIP_MSG = CreditsScreen.creditStrings.UI[0];
    private float skipTimer;
    private static final float SKIP_MENU_UP_DUR = 2.0f;
    private static final float SKIP_APPEAR_TIME = 0.5f;
    private boolean isSkippable;
    private boolean closingSkipMenu;
    private static final float SKIP_START_X = -300.0f * Settings.scale;
    private static final float SKIP_END_X = 50.0f * Settings.scale;
    private float skipX;

    public CreditsScreen() {
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.CREDITS;
        this.targetY = this.currentY = SCROLL_START_Y;
        float tmpY = -500.0f;
        this.lines.add(new CreditLine(NAMES[0], tmpY, true));
        this.lines.add(new CreditLine(NAMES[1], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[2], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[14], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[15], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[45], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[8], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[9], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[10], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[11], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[12], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[13], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[3], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[4], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[5], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[6], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[7], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[16], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[17], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[18], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[19], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[20], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[21], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[22], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[23], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[24], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[25], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[26], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[27], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[28], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[29], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[30], tmpY -= 45.0f, false, true));
        this.lines.add(new CreditLine(NAMES[31], tmpY -= 45.0f, false, true));
        tmpY += 675.0f;
        this.lines.add(new CreditLine(NAMES[32], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[33], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[34], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[35], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[36], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[37], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[38], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[39], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[40], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[41], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[42], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[43], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[52], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[53], tmpY -= 45.0f, false, false));
        this.lines.add(new CreditLine(NAMES[44], tmpY -= 150.0f, true));
        this.lines.add(new CreditLine(NAMES[46], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[47], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[48], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[49], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[50], tmpY -= 45.0f, false));
        this.lines.add(new CreditLine(NAMES[51], tmpY -= 45.0f, false));
    }

    public void open() {
        this.skipTimer = 0.0f;
        this.isSkippable = false;
        this.closingSkipMenu = false;
        this.skipX = SKIP_START_X;
        GameCursor.hidden = true;
        this.thankYouColor.a = 0.0f;
        this.thankYouTimer = 3.0f;
        CardCrawlGame.mainMenuScreen.darken();
        this.fadeInTimer = 2.0f;
        this.targetY = this.currentY = SCROLL_START_Y;
    }

    public void update() {
        if (InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            this.close();
        }
        if (InputHelper.isMouseDown_R) {
            this.targetY -= Gdx.graphics.getDeltaTime() * scrollSpeed * 4.0f;
        } else {
            this.targetY += Gdx.graphics.getDeltaTime() * scrollSpeed;
            if (this.currentY > END_OF_CREDITS_Y) {
                this.thankYouTimer -= Gdx.graphics.getDeltaTime();
                if (this.thankYouTimer < 0.0f) {
                    this.thankYouTimer = 0.0f;
                }
                this.thankYouColor.a = Interpolation.fade.apply(1.0f, 0.0f, this.thankYouTimer / 3.0f);
            }
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            this.targetY = SCROLL_START_Y;
        }
        if (InputHelper.scrolledUp) {
            this.targetY -= 100.0f * Settings.scale;
        } else if (InputHelper.scrolledDown) {
            this.targetY += 100.0f * Settings.scale;
        }
        this.currentY = MathHelper.scrollSnapLerpSpeed(this.currentY, this.targetY);
        this.updateFade();
        this.skipLogic();
    }

    private void skipLogic() {
        if (InputHelper.justClickedLeft) {
            if (this.isSkippable) {
                this.close();
            } else if (!this.isSkippable && this.skipTimer == 0.0f) {
                this.skipTimer = 0.5f;
                this.skipX = SKIP_END_X;
            }
        }
        if (this.skipTimer != 0.0f) {
            this.skipTimer -= Gdx.graphics.getDeltaTime();
            this.skipX = !this.isSkippable && !this.closingSkipMenu ? Interpolation.swingIn.apply(SKIP_END_X, SKIP_START_X, this.skipTimer * 2.0f) : (this.closingSkipMenu ? Interpolation.fade.apply(SKIP_START_X, SKIP_END_X, this.skipTimer * 2.0f) : SKIP_END_X);
            if (this.skipTimer < 0.0f) {
                if (!this.isSkippable && !this.closingSkipMenu) {
                    this.isSkippable = true;
                    this.skipTimer = 2.0f;
                } else if (!this.closingSkipMenu) {
                    this.closingSkipMenu = true;
                    this.isSkippable = false;
                    this.skipTimer = 0.5f;
                } else {
                    this.isSkippable = false;
                    this.closingSkipMenu = false;
                    this.skipTimer = 0.0f;
                }
            }
        }
    }

    public void close() {
        if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.CREDITS) {
            CardCrawlGame.mainMenuScreen.lighten();
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            GameCursor.hidden = false;
        }
    }

    private void updateFade() {
        this.fadeInTimer -= Gdx.graphics.getDeltaTime();
        if (this.fadeInTimer < 0.0f) {
            this.fadeInTimer = 0.0f;
        }
        this.screenColor.a = Interpolation.fade.apply(1.0f, 0.0f, this.fadeInTimer / 2.0f);
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.screenColor.a));
        sb.draw(ImageMaster.CREDITS_LOGO, (float)Settings.WIDTH / 2.0f - 360.0f, this.currentY - 360.0f, 360.0f, 360.0f, 720.0f, 720.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 720, 720, false, false);
        for (CreditLine c : this.lines) {
            c.render(sb, this.currentY);
        }
        FontHelper.renderFontCentered(sb, FontHelper.buttonLabelFont, THANKS_MSG, (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, this.thankYouColor);
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.panelInfoFont, SKIP_MSG, this.skipX, 50.0f * Settings.scale, Settings.BLUE_TEXT_COLOR);
    }
}

